// Money filter by Giacomo Preciado
// Based on: "Free Engraved Illustration Effect Action for Photoshop" - http://snip.ly/j0gq
// e-mail: giacomo@kyrie.pe
// website: http://kyrie.pe

#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

float myMod(float x,float y){
    return x - y * floor(x/y);
}

__kernel void MAIN(
      __read_only image2d_t input,  
      __write_only image2d_t dest_data,
      __global FilterParam* param,
	  int alpha,
      int amplitud,
     float frecuencia) 
{
    int outputW = param->width[1];
	int outputH = param->height[1];
    int W = get_global_size(0);
	int H = get_global_size(1);
    float2 ouputResolution = (float2)(W,H);
  
    int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));

    vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = ((float2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/ouputResolution.xy;
    vec2 resolution = ouputResolution;
    float roiLeft = param->origROI[0];
    float roiTop = param->origROI[1];
    float roiWidth  = param->origROI[2];
    float roiHeight  = param->origROI[3];
    //vec2 tranformCoord = (vec2)(roiWidth * tc.x + roiLeft , roiHeight * tc.y + roiTop);
    vec2 uv = (float2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);

    float gris = 1.0f;
	float factor = (float)(outputW)/640.0f;
    float divisor = (4.8f / (float)(outputH))*factor;
    float grosorInicial = divisor * 0.2f;
    float amp = (float)(amplitud)/100.0f;

    float fragX = (float)(get_global_id(0) - get_global_offset(0));
    float fragY = (float)(get_global_id(1) - get_global_offset(1));
    vec2 frag = (vec2)(fragX,fragY) + (vec2)(0.5f);
    
    vec2 xy = frag.xy / ouputResolution.xy;
   
    float4 orig = read_imagef(input, sampler, uv);  

    
    int kNumPatrones = 6;
    float3 datosPatron[6] ;
    datosPatron[0] = (float3)(-0.7071f, 0.7071f, 3.0f);
    datosPatron[1] = (float3)(0.0f, 1.0f, 0.6f);
    datosPatron[2] = (float3)(0.0f, 1.0f, 0.5f);
    datosPatron[3] = (float3)(1.0f, 0.0f, 0.4f);
    datosPatron[4] = (float3)(1.0f, 0.0f, 0.3f);
    datosPatron[5] = (float3)(0.0f, 1.0f, 0.2f);
   

    float4 color = orig;
    float4 fragColor = color;
     for(int i = 0; i < kNumPatrones; i++)
    {
        float coseno = datosPatron[i].x;
        float seno = datosPatron[i].y;
        
        // RotaciÃ³n del patrÃ³n
        float2 punto = (float2)(
            xy.x * coseno - xy.y * seno,
            xy.x * seno + xy.y * coseno
        );

        float grosor = grosorInicial * (float)(i + 1);
        float dist = myMod(punto.y + grosor * 0.5f - sin(punto.x * frecuencia) * amp, divisor);
        float brillo = 0.3f * color.x + 0.4f * color.y + 0.3f * color.z;

        if((dist < grosor) && (brillo < 0.750000f - 0.12f * (float)(i)))        
        {
            // Suavizado
            float k = datosPatron[i].z;
            float x = (grosor - dist) / grosor;
            float fx = fabs((x - 0.5f) / k) - (0.5f - k) / k; 
            gris = min(fx, gris);
        }
    }
    fragColor = (vec4)(gris,gris,gris,orig.w);
    vec4 retColor =  mix( fragColor, orig, 1.0f - (float)(alpha)/100.0f );   
    write_imagef(dest_data,gl_FragCoord,retColor);
}



